/*
 * Copyright 2016 Freescale Semiconductor
 * Copyright 2016-2017 NXP
 * To be used with MCUXpresso Config Tools under its Software License Agreement.
 */

// This object generate content of H file. The content is affected by generating C file.
var ClockConfigH = {
  // Output writer
  writer: null,
  
  // references on define block instances for "common" and for each configuration
  defineBlockH: new Object(),
  // references on define block positions for "common" and for each configuration
  defineBlockHPosition: new Object(),
  
  // generate h file content and create insertions for definitions
  generate: function(writer) {
    // safe output writer
    this.writer = writer;
    
    // HWriter.write(CommonHeaderText());
    // HWriter.write("");
    HWriter.writeLines([
    "/***********************************************************************************************************************",
    " * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file",
    " * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.",
    " **********************************************************************************************************************/",
    "",
    "#ifndef _CLOCK_CONFIG_H_",
    "#define _CLOCK_CONFIG_H_",
    "",
    "#include \"fsl_common.h\"",
    "",
    ]);
    
    // Common definitions
    this.defineBlockHPosition["common"] = HWriter.write(null); 
    HWriter.writeLines(OutputUtils.getDefinitionIntro(), this.defineBlockHPosition["common"]);
    this.defineBlockH["common"] = new DefineBlock();     
    this.defineBlockH["common"].addDefine("BOARD_XTAL0_CLK_HZ", 12000000, "Board xtal0 frequency in Hz");
    this.defineBlockH["common"].addDefine("BOARD_XTAL32K_CLK_HZ", 32768, "Board xtal32K frequency in Hz");   

    HWriter.writeLines([
    '/*******************************************************************************',
    ' ************************ BOARD_InitBootClocks function ************************',
    ' ******************************************************************************/',
    '',
    '#if defined(__cplusplus)',
    'extern "C" {',
    '#endif /* __cplusplus*/',
    '',
    '/*!',
    ' * @brief This function executes default configuration of clocks.',
    ' *',
    ' */',
    'void BOARD_InitBootClocks(void);',
    '',
    '#if defined(__cplusplus)',
    '}',
    '#endif /* __cplusplus*/',
    '']);
    
    // generate the header part for each configuration 
    for (var cfgIndex = 0; cfgIndex < Gen.configs.length; cfgIndex++) {
      var cfg = Gen.configs[cfgIndex];
      var configID = Gen.getConfigID(cfg);
      var configName = cfg.getName();
    /* Core clock branch */
      var coreFreq = cfg.getValueAsText("System_clock.outFreq");
      if (coreFreq != "N/A") {                      
        coreFreq = cfg.getValueAsBigInteger("System_clock.outFreq"); 
      }  
      // write configuration introduction
      HWriter.writeLines(OutputUtils.getConfigurationIntro(cfg));
      // write definition introduction
      HWriter.writeLines(OutputUtils.getDefinitionIntro(cfg));

      HWriter.line("#define " + configID.toUpperCase() + "_CORE_CLOCK   " + coreFreq +"U"+"    /*!< Core clock frequency:" + coreFreq+"Hz" + " */" ) 

      this.defineBlockHPosition[configID] = HWriter.write(null); 
      // create block instance of #defines 
      this.defineBlockH[configID] = new DefineBlock();
      SDKMapper.setHWriterDefineContainer = this.defineBlockH[configID];   
      // HWriter.line("");  

      // write api introduction
      HWriter.writeLines(OutputUtils.getApiIntro(cfg));
      HWriter.writeLines([
      "#if defined(__cplusplus)",
      "extern \"C\" {",
      "#endif /* __cplusplus*/"]);
      HWriter.write("");
      HWriter.writeLines([
      "/*!",
      " * @brief This function executes configuration of clocks.",
      " *",
      " */"]);
      HWriter.write("void " + Gen.getConfigID(Gen.configs[cfgIndex]) + "(void);");
      HWriter.writeLines([
      "",
      "#if defined(__cplusplus)",
      "}",
      "#endif /* __cplusplus*/",
      "",
      ]);
    }
    HWriter.writeLines([
    "#endif /* _CLOCK_CONFIG_H_ */",
    "",
    ]);    
  },
  
  // complete h file content, e.g. definition insertion
  complete: function(){
      // write common define block
    HWriter.writeLines(this.defineBlockH["common"].getDefineBlock().concat(""), this.defineBlockHPosition["common"]);
    for (var cfgIndex = 0; cfgIndex < Gen.configs.length; cfgIndex++) {
      var cfg = Gen.configs[cfgIndex];
      var configID = Gen.getConfigID(cfg);
      var configName = cfg.getName();
      // write common define block
      HWriter.writeLines(this.defineBlockH[configID].getDefineBlock().concat(""), this.defineBlockHPosition[configID]);
    }
  },
}