/*
 * Copyright 2016 Freescale Semiconductor
 * Copyright 2016-2017 NXP
 * To be used with MCUXpresso Config Tools under its Software License Agreement.
 */

// -----------------------------------------------------
function printBitFields(getFunction) {
    var bitFieldSet = cfg[getFunction]();
    if ((bitFieldSet != null) && (bitFieldSet != undefined)) {
      out.write(getFunction + "() returns (" + bitFieldSet.length + " items):");
      var bfAccess = new Array();
      for (var ri = 0; ri < bitFieldSet.length; ri++) {
        var bitFieldName = bitFieldSet[ri].getName();
        var bitFieldValue = cfg.getBitFieldValueAsBigInteger(bitFieldSet[ri]); 
        bfAccess.push(bitFieldSet[ri].getPeripheral().getName() + "_" + bitFieldSet[ri].getRegister().getName() + " -> "+ bitFieldName + " = " + BigNumber.toString(bitFieldValue));
      }
      bfAccess = bfAccess.sort();
      out.write(bfAccess.join("\n") + "\r\n");
    }  
    else {
      out.write(getFunction + "() returns null or undefined.");
    } 
}

function printSettings(getFunction) {
    var commentPos = 40;
    var idSet = cfg[getFunction]();
    var idSetNew = new Array();
    if ((idSet != null) && (idSet != undefined)) {
      out.write(getFunction + "() returns (" + idSet.length + " items):");
      for (var si = 0; si < idSet.length; si++) {
        idSetNew[si] = idSet[si];
      }
      idSetNew = idSetNew.sort();
      for (var si = 0; si < idSet.length; si++) {
        var idName = idSetNew[si];
        var idValue = cfg.getValueAsText(idSetNew[si]); 
        var idDefaultValue = cfg.getDefaultValueAsText(idSetNew[si]); 
        var line = idName + " = " + idValue;
        if (line.length < commentPos) {
          line = line.concat(Array(commentPos - line.length).join(" "));
        }
        line += "(default: " + idDefaultValue + ")";
        out.write(line);
      }
    }  
    else {
      out.write(getFunction + "() returns null or undefined.");
    } 
}

function printIds(getFunction) {
    var idSet = cfg[getFunction]();
    var idSetNew = new Array();
    if ((idSet != null) && (idSet != undefined)) {
      out.write(getFunction + "() returns (" + idSet.length + " items):");
      for (var si = 0; si < idSet.length; si++) {
        idSetNew[si] = idSet[si];
      }
      idSetNew = idSetNew.sort();
      for (var si = 0; si < idSet.length; si++) {
        var idName = idSetNew[si];
        out.write(idName);
      }
    }  
    else {
      out.write(getFunction + "() returns null or undefined.");
    } 
}

var profile = scriptApi.getProfile();
var configs = profile.getConfigurations();
if (configs != null) {
  for (var i = 0; i < configs.length; i++) {
    var cfg = configs[i];
    var configID = cfg.getName().replace(/[^\w\d]/g, "_");
    var out = scriptApi.createFile("debug_" + configID + ".txt");
    out.write("Configuration name: " + cfg.getName());
    out.write("---------------------------------------------");
    printBitFields("getConfiguredBitFields");
    out.write("---------------------------------------------");
    printBitFields("getBitFieldsNonDefault");
    out.write("---------------------------------------------");
    printSettings("getClockSourceSettings");
    out.write("---------------------------------------------");
    printSettings("getClockOutputSettings");
    out.write("---------------------------------------------");
    printSettings("getGlobalSettings");
    out.write("---------------------------------------------");
    printSettings("getGeneralSettings");
    out.write("---------------------------------------------");
    printIds("getElementIds");
    out.write("---------------------------------------------");
    printIds("getComponentIds");
  }
}