/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
 
/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/
/*
 * How to setup clock using clock driver functions:
 *
 * 1. Setup clock sources.
 *
 * 2. Set up wait states of the flash.
 *
 * 3. Set up all dividers.
 *
 * 4. Set up all selectors to provide selected clocks.
 *
 */

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Clocks v14.0
processor: MCXA346
package_id: MCXA346VLQ
mcu_data: ksdk2_0
processor_version: 0.0.0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

#include "fsl_clock.h"
#include "clock_config.h"
#include "fsl_spc.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/
/* System clock frequency. */
extern uint32_t SystemCoreClock;

/*******************************************************************************
 ************************ BOARD_InitBootClocks function ************************
 ******************************************************************************/
void BOARD_InitBootClocks(void)
{
    BOARD_BootClockFROHF180M();
}

/*******************************************************************************
 ******************** Configuration BOARD_BootClockFRO12M **********************
 ******************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!Configuration
name: BOARD_BootClockFRO12M
outputs:
- {id: BUS_clock.outFreq, value: 6 MHz}
- {id: CLK_1M_clock.outFreq, value: 1 MHz}
- {id: CLK_45M_clock.outFreq, value: 45 MHz}
- {id: CPU_clock.outFreq, value: 12 MHz}
- {id: FRO_12M_DIV_clock.outFreq, value: 12 MHz}
- {id: FRO_12M_clock.outFreq, value: 12 MHz}
- {id: FRO_HF_DIV_clock.outFreq, value: 45 MHz}
- {id: FRO_HF_clock.outFreq, value: 45 MHz}
- {id: MAIN_clock.outFreq, value: 12 MHz}
- {id: Slow_clock.outFreq, value: 2 MHz}
- {id: System_clock.outFreq, value: 12 MHz}
- {id: TRACE_clock.outFreq, value: 12 MHz}
- {id: UTICK0_clock.outFreq, value: 1 MHz}
- {id: WWDT0_clock.outFreq, value: 1 MHz}
settings:
- {id: SCGMode, value: SIRC}
- {id: VDD_CORE, value: voltage_1v2}
- {id: FROHFDIV_SYSCON_FROHFDIV_HALT, value: RUN}
- {id: FROLFDIV_SYSCON_FROLFDIV_HALT, value: RUN}
- {id: SCG.SCGSCS_CLKSEL.sel, value: SCG.FRO_12M_clock}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/*******************************************************************************
 * Variables for BOARD_BootClockFRO12M configuration
 ******************************************************************************/
/*******************************************************************************
 * Code for BOARD_BootClockFRO12M configuration
 ******************************************************************************/
void BOARD_BootClockFRO12M(void)
{
    uint32_t coreFreq;
    spc_active_mode_core_ldo_option_t ldoOption;
    spc_sram_voltage_config_t sramOption;

    /* Get the CPU Core frequency */
    coreFreq = CLOCK_GetCoreSysClkFreq();

    /* The flow of increasing voltage and frequency */
    if (coreFreq <= BOARD_BOOTCLOCKFRO12M_CORE_CLOCK) {
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x0U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
    }


    /*!< Set up system dividers */
    CLOCK_SetClockDiv(kCLOCK_DivAHBCLK, 1U);               /* !< Set SYSCON.AHBCLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_HF, 1U);               /* !< Set SYSCON.FROHFDIV divider to value 1 */
    CLOCK_SetupFROHFClocking(45000000U);               /*!< Enable FRO HF(45MHz) output */
    CLOCK_SetupFRO12MClocking();                /*!< Setup FRO12M clock */

    CLOCK_AttachClk(kFRO12M_to_MAIN_CLK);       /* !< Switch MAIN_CLK to kFRO12M */

    /* The flow of decreasing voltage and frequency */
    if (coreFreq > BOARD_BOOTCLOCKFRO12M_CORE_CLOCK) {
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x0U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
    }

    /*!< Set up clock selectors - Attach clocks to the peripheries */
    CLOCK_AttachClk(kCPU_CLK_to_TRACE);                    /* !< Switch TRACE to CPU_CLK */

    /*!< Set up dividers */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_LF, 1U);               /* !< Set SYSCON.FROLFDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivWWDT0, 1U);                /* !< Set MRCC.WWDT0_CLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivTRACE, 1U);                /* !< Set MRCC.TRACE_CLKDIV divider to value 1 */

    /* Set SystemCoreClock variable */
    SystemCoreClock = BOARD_BOOTCLOCKFRO12M_CORE_CLOCK;
}
/*******************************************************************************
 ******************* Configuration BOARD_BootClockFROHF45M *********************
 ******************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!Configuration
name: BOARD_BootClockFROHF45M
outputs:
- {id: BUS_clock.outFreq, value: 22.5 MHz}
- {id: CLK_1M_clock.outFreq, value: 1 MHz}
- {id: CLK_45M_clock.outFreq, value: 45 MHz}
- {id: CPU_clock.outFreq, value: 45 MHz}
- {id: FRO_12M_DIV_clock.outFreq, value: 12 MHz}
- {id: FRO_12M_clock.outFreq, value: 12 MHz}
- {id: FRO_HF_DIV_clock.outFreq, value: 45 MHz}
- {id: FRO_HF_clock.outFreq, value: 45 MHz}
- {id: MAIN_clock.outFreq, value: 45 MHz}
- {id: Slow_clock.outFreq, value: 7.5 MHz}
- {id: System_clock.outFreq, value: 45 MHz}
- {id: TRACE_clock.outFreq, value: 45 MHz}
- {id: UTICK0_clock.outFreq, value: 1 MHz}
- {id: WWDT0_clock.outFreq, value: 1 MHz}
settings:
- {id: VDD_CORE, value: voltage_1v2}
- {id: FROHFDIV_SYSCON_FROHFDIV_HALT, value: RUN}
- {id: FROLFDIV_SYSCON_FROLFDIV_HALT, value: RUN}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/*******************************************************************************
 * Variables for BOARD_BootClockFROHF45M configuration
 ******************************************************************************/
/*******************************************************************************
 * Code for BOARD_BootClockFROHF45M configuration
 ******************************************************************************/
void BOARD_BootClockFROHF45M(void)
{
    uint32_t coreFreq;
    spc_active_mode_core_ldo_option_t ldoOption;
    spc_sram_voltage_config_t sramOption;

    /* Get the CPU Core frequency */
    coreFreq = CLOCK_GetCoreSysClkFreq();

    /* The flow of increasing voltage and frequency */
    if (coreFreq <= BOARD_BOOTCLOCKFROHF45M_CORE_CLOCK) {
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x1U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
    }


    /*!< Set up system dividers */
    CLOCK_SetClockDiv(kCLOCK_DivAHBCLK, 1U);               /* !< Set SYSCON.AHBCLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_HF, 1U);               /* !< Set SYSCON.FROHFDIV divider to value 1 */
    CLOCK_SetupFROHFClocking(45000000U);               /*!< Enable FRO HF(45MHz) output */
    CLOCK_SetupFRO12MClocking();                /*!< Setup FRO12M clock */

    CLOCK_AttachClk(kFRO_HF_to_MAIN_CLK);       /* !< Switch MAIN_CLK to kFRO_HF */

    /* The flow of decreasing voltage and frequency */
    if (coreFreq > BOARD_BOOTCLOCKFROHF45M_CORE_CLOCK) {
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x1U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
    }

    /*!< Set up clock selectors - Attach clocks to the peripheries */
    CLOCK_AttachClk(kCPU_CLK_to_TRACE);                    /* !< Switch TRACE to CPU_CLK */

    /*!< Set up dividers */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_LF, 1U);               /* !< Set SYSCON.FROLFDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivWWDT0, 1U);                /* !< Set MRCC.WWDT0_CLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivTRACE, 1U);                /* !< Set MRCC.TRACE_CLKDIV divider to value 1 */

    /* Set SystemCoreClock variable */
    SystemCoreClock = BOARD_BOOTCLOCKFROHF45M_CORE_CLOCK;
}
/*******************************************************************************
 ******************* Configuration BOARD_BootClockFROHF60M *********************
 ******************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!Configuration
name: BOARD_BootClockFROHF60M
outputs:
- {id: BUS_clock.outFreq, value: 30 MHz}
- {id: CLK_1M_clock.outFreq, value: 1 MHz}
- {id: CLK_45M_clock.outFreq, value: 45 MHz}
- {id: CPU_clock.outFreq, value: 60 MHz}
- {id: FRO_12M_DIV_clock.outFreq, value: 12 MHz}
- {id: FRO_12M_clock.outFreq, value: 12 MHz}
- {id: FRO_HF_DIV_clock.outFreq, value: 60 MHz}
- {id: FRO_HF_clock.outFreq, value: 60 MHz}
- {id: MAIN_clock.outFreq, value: 60 MHz}
- {id: Slow_clock.outFreq, value: 10 MHz}
- {id: System_clock.outFreq, value: 60 MHz}
- {id: TRACE_clock.outFreq, value: 60 MHz}
- {id: UTICK0_clock.outFreq, value: 1 MHz}
- {id: WWDT0_clock.outFreq, value: 1 MHz}
settings:
- {id: VDD_CORE, value: voltage_1v2}
- {id: FROHFDIV_SYSCON_FROHFDIV_HALT, value: RUN}
- {id: FROLFDIV_SYSCON_FROLFDIV_HALT, value: RUN}
sources:
- {id: SCG.FIRC.outFreq, value: 60 MHz}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/*******************************************************************************
 * Variables for BOARD_BootClockFROHF60M configuration
 ******************************************************************************/
/*******************************************************************************
 * Code for BOARD_BootClockFROHF60M configuration
 ******************************************************************************/
void BOARD_BootClockFROHF60M(void)
{
    uint32_t coreFreq;
    spc_active_mode_core_ldo_option_t ldoOption;
    spc_sram_voltage_config_t sramOption;

    /* Get the CPU Core frequency */
    coreFreq = CLOCK_GetCoreSysClkFreq();

    /* The flow of increasing voltage and frequency */
    if (coreFreq <= BOARD_BOOTCLOCKFROHF60M_CORE_CLOCK) {
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x1U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
    }


    /*!< Set up system dividers */
    CLOCK_SetClockDiv(kCLOCK_DivAHBCLK, 1U);               /* !< Set SYSCON.AHBCLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_HF, 1U);               /* !< Set SYSCON.FROHFDIV divider to value 1 */
    CLOCK_SetupFROHFClocking(60000000U);               /*!< Enable FRO HF(60MHz) output */
    CLOCK_SetupFRO12MClocking();                /*!< Setup FRO12M clock */

    CLOCK_AttachClk(kFRO_HF_to_MAIN_CLK);       /* !< Switch MAIN_CLK to kFRO_HF */

    /* The flow of decreasing voltage and frequency */
    if (coreFreq > BOARD_BOOTCLOCKFROHF60M_CORE_CLOCK) {
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x1U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
    }

    /*!< Set up clock selectors - Attach clocks to the peripheries */
    CLOCK_AttachClk(kCPU_CLK_to_TRACE);                    /* !< Switch TRACE to CPU_CLK */

    /*!< Set up dividers */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_LF, 1U);               /* !< Set SYSCON.FROLFDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivWWDT0, 1U);                /* !< Set MRCC.WWDT0_CLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivTRACE, 1U);                /* !< Set MRCC.TRACE_CLKDIV divider to value 1 */

    /* Set SystemCoreClock variable */
    SystemCoreClock = BOARD_BOOTCLOCKFROHF60M_CORE_CLOCK;
}
/*******************************************************************************
 ******************* Configuration BOARD_BootClockFROHF90M *********************
 ******************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!Configuration
name: BOARD_BootClockFROHF90M
outputs:
- {id: BUS_clock.outFreq, value: 45 MHz}
- {id: CLK_1M_clock.outFreq, value: 1 MHz}
- {id: CLK_45M_clock.outFreq, value: 45 MHz}
- {id: CPU_clock.outFreq, value: 90 MHz}
- {id: FRO_12M_DIV_clock.outFreq, value: 12 MHz}
- {id: FRO_12M_clock.outFreq, value: 12 MHz}
- {id: FRO_HF_DIV_clock.outFreq, value: 90 MHz}
- {id: FRO_HF_clock.outFreq, value: 90 MHz}
- {id: MAIN_clock.outFreq, value: 90 MHz}
- {id: Slow_clock.outFreq, value: 15 MHz}
- {id: System_clock.outFreq, value: 90 MHz}
- {id: TRACE_clock.outFreq, value: 90 MHz}
- {id: UTICK0_clock.outFreq, value: 1 MHz}
- {id: WWDT0_clock.outFreq, value: 1 MHz}
settings:
- {id: VDD_CORE, value: voltage_1v2}
- {id: FROHFDIV_SYSCON_FROHFDIV_HALT, value: RUN}
- {id: FROLFDIV_SYSCON_FROLFDIV_HALT, value: RUN}
sources:
- {id: SCG.FIRC.outFreq, value: 90 MHz}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/*******************************************************************************
 * Variables for BOARD_BootClockFROHF90M configuration
 ******************************************************************************/
/*******************************************************************************
 * Code for BOARD_BootClockFROHF90M configuration
 ******************************************************************************/
void BOARD_BootClockFROHF90M(void)
{
    uint32_t coreFreq;
    spc_active_mode_core_ldo_option_t ldoOption;
    spc_sram_voltage_config_t sramOption;

    /* Get the CPU Core frequency */
    coreFreq = CLOCK_GetCoreSysClkFreq();

    /* The flow of increasing voltage and frequency */
    if (coreFreq <= BOARD_BOOTCLOCKFROHF90M_CORE_CLOCK) {
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x2U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
    }


    /*!< Set up system dividers */
    CLOCK_SetClockDiv(kCLOCK_DivAHBCLK, 1U);               /* !< Set SYSCON.AHBCLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_HF, 1U);               /* !< Set SYSCON.FROHFDIV divider to value 1 */
    CLOCK_SetupFROHFClocking(90000000U);               /*!< Enable FRO HF(90MHz) output */
    CLOCK_SetupFRO12MClocking();                /*!< Setup FRO12M clock */

    CLOCK_AttachClk(kFRO_HF_to_MAIN_CLK);       /* !< Switch MAIN_CLK to kFRO_HF */

    /* The flow of decreasing voltage and frequency */
    if (coreFreq > BOARD_BOOTCLOCKFROHF90M_CORE_CLOCK) {
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x2U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
    }

    /*!< Set up clock selectors - Attach clocks to the peripheries */
    CLOCK_AttachClk(kCPU_CLK_to_TRACE);                    /* !< Switch TRACE to CPU_CLK */

    /*!< Set up dividers */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_LF, 1U);               /* !< Set SYSCON.FROLFDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivWWDT0, 1U);                /* !< Set MRCC.WWDT0_CLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivTRACE, 1U);                /* !< Set MRCC.TRACE_CLKDIV divider to value 1 */

    /* Set SystemCoreClock variable */
    SystemCoreClock = BOARD_BOOTCLOCKFROHF90M_CORE_CLOCK;
}
/*******************************************************************************
 ******************* Configuration BOARD_BootClockFROHF180M ********************
 ******************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!Configuration
name: BOARD_BootClockFROHF180M
called_from_default_init: true
outputs:
- {id: BUS_clock.outFreq, value: 90 MHz}
- {id: CLK_1M_clock.outFreq, value: 1 MHz}
- {id: CLK_45M_clock.outFreq, value: 45 MHz}
- {id: CPU_clock.outFreq, value: 180 MHz}
- {id: FRO_12M_DIV_clock.outFreq, value: 12 MHz}
- {id: FRO_12M_clock.outFreq, value: 12 MHz}
- {id: FRO_HF_DIV_clock.outFreq, value: 180 MHz}
- {id: FRO_HF_clock.outFreq, value: 180 MHz}
- {id: MAIN_clock.outFreq, value: 180 MHz}
- {id: Slow_clock.outFreq, value: 30 MHz}
- {id: System_clock.outFreq, value: 180 MHz}
- {id: TRACE_clock.outFreq, value: 90 MHz}
- {id: UTICK0_clock.outFreq, value: 1 MHz}
- {id: WWDT0_clock.outFreq, value: 1 MHz}
settings:
- {id: VDD_CORE, value: voltage_1v2}
- {id: FROHFDIV_SYSCON_FROHFDIV_HALT, value: RUN}
- {id: FROLFDIV_SYSCON_FROLFDIV_HALT, value: RUN}
- {id: MRCC.TRACE_CLKDIV.scale, value: '2', locked: true}
sources:
- {id: SCG.FIRC.outFreq, value: 180 MHz}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/*******************************************************************************
 * Variables for BOARD_BootClockFROHF180M configuration
 ******************************************************************************/
/*******************************************************************************
 * Code for BOARD_BootClockFROHF180M configuration
 ******************************************************************************/
void BOARD_BootClockFROHF180M(void)
{
    uint32_t coreFreq;
    spc_active_mode_core_ldo_option_t ldoOption;
    spc_sram_voltage_config_t sramOption;

    /* Get the CPU Core frequency */
    coreFreq = CLOCK_GetCoreSysClkFreq();

    /* The flow of increasing voltage and frequency */
    if (coreFreq <= BOARD_BOOTCLOCKFROHF180M_CORE_CLOCK) {
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x4U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
    }


    /*!< Set up system dividers */
    CLOCK_SetClockDiv(kCLOCK_DivAHBCLK, 1U);               /* !< Set SYSCON.AHBCLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_HF, 1U);               /* !< Set SYSCON.FROHFDIV divider to value 1 */
    CLOCK_SetupFROHFClocking(180000000U);              /*!< Enable FRO HF(180MHz) output */
    CLOCK_SetupFRO12MClocking();                /*!< Setup FRO12M clock */

    CLOCK_AttachClk(kFRO_HF_to_MAIN_CLK);       /* !< Switch MAIN_CLK to kFRO_HF */

    /* The flow of decreasing voltage and frequency */
    if (coreFreq > BOARD_BOOTCLOCKFROHF180M_CORE_CLOCK) {
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x4U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
    }

    /*!< Set up clock selectors - Attach clocks to the peripheries */
    CLOCK_AttachClk(kCPU_CLK_to_TRACE);                    /* !< Switch TRACE to CPU_CLK */

    /*!< Set up dividers */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_LF, 1U);               /* !< Set SYSCON.FROLFDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivWWDT0, 1U);                /* !< Set MRCC.WWDT0_CLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivTRACE, 2U);                /* !< Set MRCC.TRACE_CLKDIV divider to value 2 */

    /* Set SystemCoreClock variable */
    SystemCoreClock = BOARD_BOOTCLOCKFROHF180M_CORE_CLOCK;
}
/*******************************************************************************
 ******************** Configuration BOARD_BootClockPLL180M *********************
 ******************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!Configuration
name: BOARD_BootClockPLL180M
outputs:
- {id: BUS_clock.outFreq, value: 90 MHz}
- {id: CLK_1M_clock.outFreq, value: 1 MHz}
- {id: CLK_45M_clock.outFreq, value: 45 MHz}
- {id: CPU_clock.outFreq, value: 180 MHz}
- {id: FRO_12M_DIV_clock.outFreq, value: 12 MHz}
- {id: FRO_12M_clock.outFreq, value: 12 MHz}
- {id: FRO_HF_DIV_clock.outFreq, value: 45 MHz}
- {id: FRO_HF_clock.outFreq, value: 45 MHz}
- {id: MAIN_clock.outFreq, value: 180 MHz}
- {id: PLL1_DIV_clock.outFreq, value: 45 MHz}
- {id: PLL1_clock.outFreq, value: 180 MHz}
- {id: Slow_clock.outFreq, value: 30 MHz}
- {id: System_clock.outFreq, value: 180 MHz}
- {id: TRACE_clock.outFreq, value: 90 MHz}
- {id: UTICK0_clock.outFreq, value: 1 MHz}
- {id: WWDT0_clock.outFreq, value: 1 MHz}
settings:
- {id: PLL_MODE, value: Normal}
- {id: SCGMode, value: PLL1}
- {id: VDD_CORE, value: voltage_1v2}
- {id: FROHFDIV_SYSCON_FROHFDIV_HALT, value: RUN}
- {id: FROLFDIV_SYSCON_FROLFDIV_HALT, value: RUN}
- {id: MRCC.TRACE_CLKDIV.scale, value: '2', locked: true}
- {id: PLL1CLKDIV_SYSCON_PLL1CLKDIV_HALT, value: RUN}
- {id: SCG.MDIV.scale, value: '30', locked: true}
- {id: SCG.NDIV.scale, value: '1', locked: true}
- {id: SCG.PLL1_CLKSEL.sel, value: SCG.FRO_12M_clock}
- {id: SCG.SCGSCS_CLKSEL.sel, value: SCG.PLL1_clock}
- {id: SYSCON.PLL1CLKDIV.scale, value: '4', locked: true}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/*******************************************************************************
 * Variables for BOARD_BootClockPLL180M configuration
 ******************************************************************************/
/*******************************************************************************
 * Code for BOARD_BootClockPLL180M configuration
 ******************************************************************************/
void BOARD_BootClockPLL180M(void)
{
    uint32_t coreFreq;
    spc_active_mode_core_ldo_option_t ldoOption;
    spc_sram_voltage_config_t sramOption;

    /* Get the CPU Core frequency */
    coreFreq = CLOCK_GetCoreSysClkFreq();

    /* The flow of increasing voltage and frequency */
    if (coreFreq <= BOARD_BOOTCLOCKPLL180M_CORE_CLOCK) {
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x4U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
    }


    /*!< Set up system dividers */
    CLOCK_SetClockDiv(kCLOCK_DivAHBCLK, 1U);               /* !< Set SYSCON.AHBCLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_HF, 1U);               /* !< Set SYSCON.FROHFDIV divider to value 1 */
    CLOCK_SetupFROHFClocking(45000000U);               /*!< Enable FRO HF(45MHz) output */
    CLOCK_SetupFRO12MClocking();                /*!< Setup FRO12M clock */

    /*!< Set up PLL1 */
    const pll_setup_t pll1Setup = {
        .pllctrl = SCG_SPLLCTRL_SOURCE(3U) | SCG_SPLLCTRL_SELI(17U) | SCG_SPLLCTRL_SELP(8U),
        .pllndiv = SCG_SPLLNDIV_NDIV(1U),
        .pllpdiv = SCG_SPLLPDIV_PDIV(1U),
        .pllmdiv = SCG_SPLLMDIV_MDIV(30U),
        .pllRate = 180000000U
    };
    CLOCK_SetPLL1Freq(&pll1Setup);                       /*!< Configure PLL1 to the desired values */
    CLOCK_SetPll1MonitorMode(kSCG_Pll1MonitorDisable);    /* Pll1 Monitor is disabled */

    CLOCK_AttachClk(kPll1Clk_to_MAIN_CLK);      /* !< Switch MAIN_CLK to kPll1Clk */

    /* The flow of decreasing voltage and frequency */
    if (coreFreq > BOARD_BOOTCLOCKPLL180M_CORE_CLOCK) {
        /* Configure Flash to support different voltage level and frequency */
        FMU0->FCTRL = (FMU0->FCTRL & ~((uint32_t)FMU_FCTRL_RWSC_MASK)) | (FMU_FCTRL_RWSC(0x4U));
        /* Specifies the operating voltage for the SRAM's read/write timing margin */
        sramOption.operateVoltage = kSPC_sramOperateAt1P2V;
        sramOption.requestVoltageUpdate =  true;
        (void)SPC_SetSRAMOperateVoltage(SPC0, &sramOption);
        /* Set the LDO_CORE VDD regulator level */
        ldoOption.CoreLDOVoltage = kSPC_CoreLDO_OverDriveVoltage;
        ldoOption.CoreLDODriveStrength = kSPC_CoreLDO_NormalDriveStrength;
        (void)SPC_SetActiveModeCoreLDORegulatorConfig(SPC0, &ldoOption);
    }

    /*!< Set up clock selectors - Attach clocks to the peripheries */
    CLOCK_AttachClk(kCPU_CLK_to_TRACE);                    /* !< Switch TRACE to CPU_CLK */

    /*!< Set up dividers */
    CLOCK_SetClockDiv(kCLOCK_DivFRO_LF, 1U);               /* !< Set SYSCON.FROLFDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivPLL1CLK, 4U);              /* !< Set SYSCON.PLL1CLKDIV divider to value 4 */
    CLOCK_SetClockDiv(kCLOCK_DivWWDT0, 1U);                /* !< Set MRCC.WWDT0_CLKDIV divider to value 1 */
    CLOCK_SetClockDiv(kCLOCK_DivTRACE, 2U);                /* !< Set MRCC.TRACE_CLKDIV divider to value 2 */

    /* Set SystemCoreClock variable */
    SystemCoreClock = BOARD_BOOTCLOCKPLL180M_CORE_CLOCK;
}
